"""
HB_SmoothEdgeCancel V1.1

Last Modified: Oct/10/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_SmoothEdgeCancel
Description-US: Cancels the SmoothEdge Script if you want to exit without changes to the Mesh.

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=28m16s

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/10/2018 V1.1
- Python rewrite

"""

import c4d
from c4d import gui


def Cancel(obj):
    obj.SetBit(c4d.BIT_ACTIVE)
    c4d.CallCommand(100004768)# Select Children
    obj.DelBit(c4d.BIT_ACTIVE)
    c4d.CallCommand(100004787)#Delete
    obj.SetBit(c4d.BIT_ACTIVE)
    objtags=obj.GetTags()
    for tag in objtags:
        if tag.GetName()=="HB_Smoothedge_Restriction":
            tag.Remove()
            


def main():
    if len(doc.GetSelection()) > 1:
        gui.MessageDialog("Select only one Object")
        return
    
    
    obj=doc.GetActiveObject()
    objtype=obj.GetType()
    if objtype==c4d.Opolygon:
        Cancel(obj)
        
       
    else:
        newobj=obj.GetUp()
        newobj.SetBit(c4d.BIT_ACTIVE)  
        Cancel(newobj)
        


if __name__=='__main__':
    main()
